/******************** (C) COPYRIGHT 2003 STMicroelectronics ********************
* File Name          : main.c
* Author             : MCD Application Team
* Date First Issued  : 18/07/2003
* Description        : This file is used for the STR71x Real Time 
*                      Clock Application Example application note (AN 1780).
********************************************************************************
* History:
*  04/10/2003 : V1.0
*  30/11/2004 : V2.0
*******************************************************************************
 THE PRESENT SOFTWARE WHICH IS FOR GUIDANCE ONLY AIMS AT PROVIDING CUSTOMERS WITH
 CODING INFORMATION REGARDING THEIR PRODUCTS IN ORDER FOR THEM TO SAVE TIME.
 AS A RESULT, STMICROELECTRONICS SHALL NOT BE HELD LIABLE FOR ANY DIRECT, INDIRECT
 OR CONSEQUENTIAL DAMAGES WITH RESPECT TO ANY CLAIMS ARISING FROM THE CONTENT
 OF SUCH SOFTWARE AND/OR THE USE MADE BY CUSTOMERS OF THE CODING INFORMATION
 CONTAINED HEREIN IN CONNECTION WITH THEIR PRODUCTS.
*******************************************************************************/

#include "71x_lib.h"
#include "lcd.h"
#include <stdio.h>
#include <time.h>
#include <stdlib.h>

#define RTC_PRESC 0x8000

  time_t TIME;
  struct tm *ptim;
  RCCU_ResetSources ResetSources;
int main(void)
{ 
  RTC_FlagClear ( RTC_OWIR );
  RTC_FlagClear ( RTC_AIR  );
  RTC_FlagClear ( RTC_SIR  );
  RTC_FlagClear ( RTC_GIR  );
  RTC_PrescalerConfig(RTC_PRESC);
  ptim=malloc(sizeof(*ptim));
  printf("s:");
  scanf("%d, ",&ptim->tm_sec);
  printf("m:");
  scanf("%d, ",&ptim->tm_min);
  printf("h:");
  scanf("%d",&ptim->tm_hour);
  printf("D:");
  scanf("%d,",&ptim->tm_mday);
  printf("M:");
  scanf("%d,",&ptim->tm_mon);
  ptim->tm_mon--;
  printf("Y:");
  scanf("%d",&ptim->tm_year);
  ptim->tm_year-=1900;
  TIME = mktime(ptim)-0x3FF36300;
  RTC_WaitForLastTask();
  // Enter In Configuration Mode
  RTC_EnterCfgMode();
  // Wait For Last Task Completion
  RTC_WaitForLastTask();
  // Wait For Last Task Completion
  RTC->CNTL = TIME & 0x0000FFFF;
  // Wait For Last Task Completion
  RTC_WaitForLastTask();
  RTC->CNTH = ( TIME & 0xFFFF0000 ) >> 16;
  // Wait For Last Task Completion
  RTC_WaitForLastTask();
  // Exit From Configuration Mode
  RTC_ExitCfgMode ();

//  RTC_AlarmConfig(TIME+15);


  RTC_AlarmConfig(RTC_CounterValue()+5);
// Enable RTC IRQ channel
  EIC_IRQChannelConfig( RTC_IRQChannel, ENABLE );
  EIC_IRQChannelPriorityConfig( RTC_IRQChannel, 1);
  EIC_IRQConfig( ENABLE );

// Enable alarm Interrupt
  RTC_ITConfig( RTC_AIT|RTC_GIT, ENABLE );

//  LCD_UnderlineCursorOff();
  gotoxy(1,1);
  printf("                ");
  gotoxy(1,2);
  printf("                ");

  while(1)
  {
    TIME=RTC_CounterValue()+0x3FF36300;
    ptim = localtime(&TIME);
    gotoxy(1,1);
    printf("   %02d/",ptim->tm_mday);
    printf("%02d/",ptim->tm_mon+1);
    printf("%4d\r\n",ptim->tm_year+1900);
    gotoxy(1,2);
    printf("  %02d : ",ptim->tm_hour);
    printf("%02d : ",ptim->tm_min);
    printf("%02d\r\n",ptim->tm_sec);
  }
}

